/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWSession;
import java.io.Serializable;
import java.text.Collator;

public final class VWApplicationSpace
implements Serializable {
    private static final long serialVersionUID = 7424L;
    protected VWAttributeInfo m_attributes = null;
    protected String m_description = null;
    protected int m_objId = -1;
    protected String m_name = null;
    protected int m_revision = -1;
    protected VWRole[] m_roles = null;
    protected VWSession m_session = null;
    private String m_desc = null;

    protected VWApplicationSpace(int revision, String name, String description, VWAttributeInfo attributes, VWRole[] roleArray) {
        this.m_revision = revision;
        this.m_name = name;
        this.m_description = description;
        this.m_attributes = attributes;
        this.m_roles = roleArray;
    }

    protected void setObjId(int objId) {
        this.m_objId = objId;
    }

    protected void setVWSession(VWSession session) {
        this.m_session = session;
        if (this.m_roles != null) {
            for (int i = 0; i < this.m_roles.length; ++i) {
                if (this.m_roles[i] == null) continue;
                this.m_roles[i].setVWSession(session);
            }
        }
    }

    public VWAttributeInfo getAttributeInfo() {
        return this.m_attributes;
    }

    public String getAuthoredName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getId() {
        return this.m_objId;
    }

    public String getName() {
        try {
            if (this.m_session != null) {
                return this.m_session.translate(this.m_name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_name;
    }

    public int getRevision() {
        return this.m_revision;
    }

    public VWRole[] getRoles() throws VWException {
        VWRole[] retArray = null;
        if (this.m_roles != null) {
            retArray = new VWRole[this.m_roles.length];
            System.arraycopy(this.m_roles, 0, retArray, 0, this.m_roles.length);
        }
        return retArray;
    }

    public VWRole getRole(String roleName) throws VWException {
        VWRole ret = null;
        if (this.m_roles != null) {
            if (this.m_session != null) {
                roleName = this.m_session.translateToAuthored(roleName);
            }
            Collator myCollator = Collator.getInstance();
            for (int i = 0; i < this.m_roles.length; ++i) {
                if (myCollator.compare(this.m_roles[i].getAuthoredName(), roleName) != 0) continue;
                ret = this.m_roles[i];
                break;
            }
        }
        return ret;
    }

    public String toString() {
        if (this.m_desc == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("VWApplicationSpace: ");
            buf.append(this.m_name);
            buf.append("[");
            buf.append(this.m_revision);
            buf.append("]");
            buf.append(", ");
            buf.append(this.m_description);
            this.m_desc = buf.toString();
        }
        return this.m_desc;
    }
}

